//=============================================================================
// Steak.
//=============================================================================
class Steak extends MSMTLSoyMeals;

#exec TEXTURE IMPORT NAME="SteakWhite" FILE="C:\DeusEx\MarkistanCity\Textures\SteakWhite.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="SteakRed" FILE="C:\DeusEx\MarkistanCity\Textures\SteakRed.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="SteakBits" FILE="C:\DeusEx\MarkistanCity\Textures\SteakBits.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="SteakDarkRed" FILE="C:\DeusEx\MarkistanCity\Textures\SteakDarkRed.pcx" GROUP=Skins

#exec MESH IMPORT MESH=Steak ANIVFILE=MODELS\Steak_a.3d DATAFILE=MODELS\Steak_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Steak X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=Steak SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Steak SEQ=Steak STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=Steak MESH=Steak
#exec MESHMAP SCALE MESHMAP=Steak X=0.0214850 Y=0.0214850 Z=0.0214850

#exec MESHMAP SETTEXTURE MESHMAP=Steak NUM=0 TEXTURE=SteakRed
#exec MESHMAP SETTEXTURE MESHMAP=Steak NUM=1 TEXTURE=SteakWhite
#exec MESHMAP SETTEXTURE MESHMAP=Steak NUM=2 TEXTURE=SteakBits
#exec MESHMAP SETTEXTURE MESHMAP=Steak NUM=3 TEXTURE=SteakDarkRed

#exec TEXTURE IMPORT NAME=IconSteak FILE=Textures\IconSteak.PCX GROUP=Icons FLAGS=2// Icon


function inventory SpawnCopy( pawn Other )
{
	local inventory Copy;

	Copy = Super.SpawnCopy(Other);
	Copy.bTossedOut = False;

	return Copy;
}

function DropFrom(vector StartLocation)
{

   if (Level.Netmode != NM_Standalone)
      bTossedOut = true;
	Super.DropFrom(StartLocation);
}

function BecomePickup()
{
	Super.BecomePickup();

   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 15.0;
}

defaultproperties
{
     healAmount=125
     maxCopies=5
     bCanHaveMultipleCopies=True
     InventoryGroup=171
     bActivatable=True
     ItemName="Steak"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'Steak'
     PickupViewMesh=LodMesh'Steak'
     ThirdPersonMesh=LodMesh'Steak'
     Icon=Texture'IconSteak'
     LargeIcon=Texture'IconSteak'
     largeIconWidth=42
     largeIconHeight=46
     Description="A juicy steak, nothing more need be said."
     beltDescription="STEAK"
     Mesh=LodMesh'Steak'
     CollisionRadius=8.000000
     CollisionHeight=0.980000
     Mass=3.000000
     Buoyancy=4.000000
}
